
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 30 10:17:10 2004
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief AES external application ATP tests  
   *
   *  \version CRYS_Ext_ATP_AES_Acceptance.c#1:csrc:1
   *  \author 
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "CRYS.h"

#include "CRYS_Ext_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_Ext_ATP_AES_Acceptance.h"
#include "CRYS_Ext_ATP_AES_Acceptance_test_vectors.h"
#include "CRYS_HOST_TST_AES.h"

#include "DX_VOS_Mem.h"


/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/
static CRYS_AES_EncryptMode_t TST_EncryptMode[] = { CRYS_AES_Encrypt , CRYS_AES_Decrypt };

char FailureFunctionNameOut[FailureFunctionName_K_Size];
static char* encryptModeStr[] = {"Encrypt mode", "Decrypt mode"};
/************* Private function prototype ***********************/
/************************ Public Functions ******************************/

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ExtApp_ATP_AES_NON_integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES non integrated function,
 *  implemented as external SEP application                          .
 *  This function Encrypts and Decrypts known vectors using AES
 *  AES modes                   -  ECB
 *  Vector sizes used (in bytes) - 1536                                 
 *  Key Size used (in bits)     - 256
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. Call the SEPQA_AES_NotIntegrated function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 ******************************************************************************/                                
CRYSError_t CRYS_ExtApp_ATP_AES_NON_integrated ( void ) 
{

    /********* TST Variables Definitions ************/
    int                     TST_index = 0;
    
    CRYSError_t             TST_TestStatus=0;
    int                     TST_OutputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
    
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_AES_NON_integrated"; 

    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************* \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_ExtApp_ATP_AES_NON_integrated Tests ********************* \n"));      
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************* \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    for (TST_OutputLocation =0 ; TST_OutputLocation < 2 ;TST_OutputLocation++) 
    {
        for (TST_ATP_EncryptDecryptFlag = 0; TST_ATP_EncryptDecryptFlag < 2 ; TST_ATP_EncryptDecryptFlag++)     /*Select mode or operation  
                                                                                                          TST_OperationMode = 0 == Encrypt
                                                                                                          TST_OperationMode = 1 == Decrypt*/
		{           
            if (TST_OutputLocation == 0) /*Select output buffer*/
			{   
				/* output buffer != input buffer    */
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n")); 
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s [test 1A.%d] \n",SEP_AES_Acceptance_TestData[TST_index].TST_Name,TST_index ));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   output buffer != input buffer                                       \n"));         
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s              \n", encryptModeStr[TST_ATP_EncryptDecryptFlag]));         
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n")); 
			}
			else
			{
				/* output buffer == input buffer    */
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n")); 
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s [test 1B.%d] \n",SEP_AES_Acceptance_TestData[TST_index].TST_Name,TST_index));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   output buffer == input buffer (output buffer)                       \n"));                             
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s              \n", encryptModeStr[TST_ATP_EncryptDecryptFlag]));         
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************************************************************** \n "));
			}
			
            
			TST_TestStatus = TESTPASS;

			/* calling the AES ATP SEP function */ 
			/*----------------------------------*/
			TST_ATP_Error = SEPQA_AES_NotIntegrated(
				SEP_AES_Acceptance_TestData[TST_index].TST_IvCounter,
				SEP_AES_Acceptance_TestData[TST_index].TST_Key,
				SEP_AES_Acceptance_TestData[TST_index].TST_KeySize,
				TST_EncryptMode[TST_ATP_EncryptDecryptFlag],
				SEP_AES_Acceptance_TestData[TST_index].TST_OperationMode,
				DX_FALSE,
				SEP_AES_Acceptance_TestData[TST_index].TST_input_data, 
				SEP_AES_Acceptance_TestData[TST_index].TST_dataSize,
				SEP_AES_Acceptance_TestData[TST_index].TST_Expected_output_data,
				SEP_AES_Acceptance_TestData[TST_index].TST_dataSize,
				TST_OutputLocation,
				FailureFunctionNameOut,
				FailureFunctionName_K_Size
				);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_AES_NotIntegrated",(char*)FailureFunctionNameOut,TST_MasterTestName);                   

#if CRYS_ATP_TST_EXIT_ON_ERROR
			if (TST_TestStatus != TESTPASS) 
				return TESTFAIL;
#endif  	                                
        }/* End of TST_ATP_EncryptDecryptFlag*/         
    } /* End of TST_OutputLocation loop*/
  return TST_TestStatus;
}/* End of CRYS_Ext_ATP_AES_Acceptance_NON_integrated*/




/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ExtApp_ATP_AES_Integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES integrated API,
 *  implemented as external SEP application                          .                           
 *  This function Encrypts and Decrypts known vectors using AES
 *  AES modes                    - ECB   
 *  Vector sizes used (in bytes) - 1536                                 
 *  Key Size used (in bits)      - 256                              
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. Call the SEPQA_AES_Integrated function to use the AES encryption/decryption process
 * 2. Verify function succeded according to the returned error code
 *
 ******************************************************************************/    
CRYSError_t CRYS_ExtApp_ATP_AES_Integrated ( void ) 
{

    /********* TST Variables Definitions ************/
    int              TST_index = 0; 
    CRYSError_t      TST_TestStatus=0;
    int              TST_OutputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
    char             TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_AES_Acceptance_Integrated";
    /********* TST Variables initialization *********/
    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************* \n")); 
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ** CRYS_ATP_TST_AES_Acceptance_Integrated Tests     ********************* \n"));     
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************* \n \n"));

    
    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    for (TST_OutputLocation =0 ; TST_OutputLocation < 2 ;TST_OutputLocation++) 
    {
        for (TST_ATP_EncryptDecryptFlag = 0; TST_ATP_EncryptDecryptFlag < 2 ; TST_ATP_EncryptDecryptFlag++) /*Select mode or operation  
                                                                                                      TST_OperationMode = 0 == Encrypt
                                                                                                      TST_OperationMode = 1 == Decrypt*/
        {
			if (TST_OutputLocation == 0)/*Select output buffer*/ 
			{   
				/* output buffer != input buffer    */
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************** \n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 2A.%d]  **\n",SEP_AES_Acceptance_TestData[TST_index].TST_Name,TST_index));   
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer != input buffer                                       \n"));                    
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s              \n", encryptModeStr[TST_ATP_EncryptDecryptFlag]));         
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ********************************************************************** \n"));
			}
			else
			{
				/* output buffer == input buffer    */
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************************************************************ \n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 2B.%d]   **\n",SEP_AES_Acceptance_TestData[TST_index].TST_Name,TST_index));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer == input buffer (output buffer)                         \n"));                      
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s              \n", encryptModeStr[TST_ATP_EncryptDecryptFlag]));         
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************************************************************ \n"));
			}

			/* calling the AES ATP SEP function */ 
			/*----------------------------------*/
			TST_ATP_Error = SEPQA_AES_Integrated(
				SEP_AES_Acceptance_TestData[TST_index].TST_IvCounter,
				SEP_AES_Acceptance_TestData[TST_index].TST_Key,
				SEP_AES_Acceptance_TestData[TST_index].TST_KeySize,
				TST_EncryptMode[TST_ATP_EncryptDecryptFlag],
				SEP_AES_Acceptance_TestData[TST_index].TST_OperationMode,
				DX_FALSE,
				SEP_AES_Acceptance_TestData[TST_index].TST_input_data, 
				SEP_AES_Acceptance_TestData[TST_index].TST_dataSize,
				SEP_AES_Acceptance_TestData[TST_index].TST_Expected_output_data,
				SEP_AES_Acceptance_TestData[TST_index].TST_dataSize,
				TST_OutputLocation,
				FailureFunctionNameOut,
				FailureFunctionName_K_Size
				);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_AES_Integrated",(char*)FailureFunctionNameOut,TST_MasterTestName);                   

#if CRYS_ATP_TST_EXIT_ON_ERROR
			if (TST_TestStatus != TESTPASS) 
				return TESTFAIL;
#endif  
        }/* End of TST_ATP_EncryptDecryptFlag*/         
    } /* End of TST_OutputLocation loop*/
  return TST_TestStatus;
}/* End of CRYS_Ext_ATP_TST_AES_Acceptance_Integrated */
/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/




/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ExtApp_ATP_AES_Acceptance_MAC_NON_integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using AES
 *  AES modes                   - MAC   
 *  Vector sizes used (in bytes) - 16/32/512/1536                     
 *  Key Size used (in bits)     - 128/192/256                               
 *  This also outputs the results to an output buffer or the same input buffer
  * Algorithm:       
 * 1. Call the SEPQA_AES_MAC_NON_Integrated function to use the AES encryption/decryption process
 * 2. Verify function succeded according to the returned error code                                              
 *
 ******************************************************************************/


CRYSError_t CRYS_ExtApp_ATP_AES_Acceptance_MAC_NON_integrated ( void ) 
{

	/********* TST Variables Definitions ************/
	int                     TST_index = 0;
	CRYSError_t             TST_TestStatus=0;
	int                     TST_OutputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
	char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_AES_Acceptance_MAC_NON_integrated"; 

	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*****************************************************************************\n"));
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_ExtApp_ATP_AES_Acceptance_MAC_NON_integrated CBC MAC Tests *********************\n"));       
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*****************************************************************************\n\n")); 

	/************************************************/
	/*********** Start of test **********************/
	/************************************************/
	TST_ATP_EncryptDecryptFlag = 0; 

    for (TST_OutputLocation =0 ; TST_OutputLocation < 2 ;TST_OutputLocation++) 
	{
		if (TST_OutputLocation == 0) 
		{   
			/* output buffer != input buffer    */
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************************************************************\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  %s[test 3A.%d]\n",SEP_AES_MAC_Acceptance_TestData[TST_index].TST_Name,TST_index )); 
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  output buffer != input buffer                                     \n"));        
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************************************************************\n"));
		}
		else
		{
			/* output buffer == input buffer    */
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************************************************************\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  %s[test 3B.%d]\n",SEP_AES_MAC_Acceptance_TestData[TST_index].TST_Name,TST_index));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  output buffer == input buffer (output buffer)                      \n"));                           
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************************************************************\n"));
		}

		TST_TestStatus = TESTPASS;

		/* calling the AES ATP SEP function */ 
		/*----------------------------------*/
		TST_ATP_Error = SEPQA_AES_MAC_NON_Integrated(
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_IvCounter,
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_Key,
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_KeySize,
			TST_EncryptMode[TST_ATP_EncryptDecryptFlag],
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_OperationMode,
			DX_FALSE,
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_input_data, 
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_dataSize,
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_Expected_CBC_MAC,
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_dataSize,
			TST_OutputLocation,
			FailureFunctionNameOut,
			FailureFunctionName_K_Size
			);

		TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_AES_MAC_NON_Integrated",FailureFunctionNameOut,TST_MasterTestName);                   


		#if CRYS_ATP_TST_EXIT_ON_ERROR
				if (TST_TestStatus != TESTPASS) 
					return TESTFAIL;
		#endif  	            
    }/* End of TST_OutputLocation loop*/
	return TST_TestStatus;
}

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************/

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ExtApp_ATP_AES_Acceptance_XCBC_CMAC_NON_integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using AES new modes
 *  XCBC and CMAC
 *  AES modes                   - MAC   
 *  Vector sizes used (in bytes) - 16/32/512/1536                     
 *  Key Size used (in bits)     - 128/ 192 CMAC only / 256 CMAC only                              
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. call to SEPQA_AES_XCBC_CMAC_NON_integrated function                                                  
 *
 ******************************************************************************/

CRYSError_t CRYS_ExtApp_ATP_AES_Acceptance_XCBC_CMAC_NON_integrated ( void ) 
{

	/********* TST Variables Definitions ************/
	int                     TST_index = 0;
	CRYSError_t             TST_TestStatus=0;
	int                     TST_OutputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
	char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_AES_Acceptance_XCBC_CMAC_NON_integrated"; 

	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"***************************************************************************************\n"));
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_ExtApp_ATP_AES_Acceptance_XCBC_CMAC_NON_integrated XCBC/CMAC MAC Tests *********************\n"));       
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"***************************************************************************************\n\n")); 

	/************************************************/
	/*********** Start of test **********************/
	/************************************************/
	TST_ATP_EncryptDecryptFlag = 0; 

	for (TST_OutputLocation =0 ; TST_OutputLocation < 2 ;TST_OutputLocation++) 
	{
		if (TST_OutputLocation == 0) 
		{   
			/* output buffer != input buffer    */
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************************************************************\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  %s[test 3A.%d]\n",SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_Name,TST_index )); 
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  output buffer != input buffer                                     \n"));        
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************************************************************\n"));
		}
		else
		{
			/* output buffer == input buffer    */
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************************************************************\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  %s[test 3B.%d]\n",SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_Name,TST_index));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  output buffer == input buffer (output buffer)                      \n"));                           
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************************************************************\n"));
		}

		TST_TestStatus = TESTPASS;
		/* calling the AES ATP SEP function */ 
		/*----------------------------------*/
		TST_ATP_Error = SEPQA_AES_XCBC_CMAC_NON_integrated(
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_Key,
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_KeySize,
			TST_EncryptMode[TST_ATP_EncryptDecryptFlag],
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_OperationMode,
			DX_FALSE,
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_input_data, 
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_dataSize,
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_Expected_CBC_MAC,
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_dataSize,
			TST_OutputLocation,
			FailureFunctionNameOut,
			FailureFunctionName_K_Size
			);		


		TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_AES_XCBC_CMAC_NON_integrated",FailureFunctionNameOut,TST_MasterTestName); 
		#if CRYS_ATP_TST_EXIT_ON_ERROR
			if (TST_TestStatus != TESTPASS) 
					return TESTFAIL;
		#endif
	}/* End of TST_OutputLocation loop*/
	return TST_TestStatus;
} 

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************/

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ExtApp_ATP_AES_Acceptance_XCBC_CMAC_integrated     
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using AES new modes
 *  XCBC and CMAC
 *  AES modes                   - MAC   
 *  Vector sizes used (in bytes) -1536                     
 *  Key Size used (in bits)     - 256 CMAC only                              
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. call to SEPQA_AES_XCBC_CMAC_integrated function                                                  
 *
 ******************************************************************************/


CRYSError_t CRYS_ExtApp_ATP_AES_Acceptance_XCBC_CMAC_integrated ( void ) 
{

	/********* TST Variables Definitions ************/
	int                     TST_index = 0;    
	CRYSError_t             TST_TestStatus=0;
	int                     TST_OutputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
	char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_AES_Acceptance_XCBC_CMAC_integrated"; 

	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"***************************************************************************************\n"));
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_ExtApp_ATP_AES_Acceptance_XCBC_CMAC_integrated XCBC/CMAC Tests *********************\n"));       
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"***************************************************************************************\n\n")); 

	/************************************************/
	/*********** Start of test **********************/
	/************************************************/
	TST_ATP_EncryptDecryptFlag = 0; 

	for (TST_OutputLocation =0 ; TST_OutputLocation < 2 ;TST_OutputLocation++) 
	{
		if (TST_OutputLocation == 0) 
		{   
			/* output buffer != input buffer    */
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************************************************************\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  %s[test 3A.%d]\n",SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_Name,TST_index )); 
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  output buffer != input buffer                                     \n"));        
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************************************************************\n"));
		}
		else
		{
			/* output buffer == input buffer    */
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************************************************************\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  %s[test 3B.%d]\n",SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_Name,TST_index));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  output buffer == input buffer (output buffer)                      \n"));                           
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************************************************************\n"));
		}

		TST_TestStatus = TESTPASS;
		/* calling the AES ATP SEP function */ 
		/*----------------------------------*/
		TST_ATP_Error = SEPQA_AES_XCBC_CMAC_integrated(
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_Key,
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_KeySize,
			TST_EncryptMode[TST_ATP_EncryptDecryptFlag],
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_OperationMode,
			DX_FALSE,
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_input_data, 
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_dataSize,
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_Expected_CBC_MAC,
			SEP_AES_XCBC_CMAC_Acceptance_TestData[TST_index].TST_dataSize,
			TST_OutputLocation,
			FailureFunctionNameOut,
			FailureFunctionName_K_Size
			);		

		TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_AES_XCBC_CMAC_Integrated",FailureFunctionNameOut,TST_MasterTestName); 
		#if CRYS_ATP_TST_EXIT_ON_ERROR
				if (TST_TestStatus != TESTPASS) 
					return TESTFAIL;
		#endif
	}/* End of TST_OutputLocation loop*/
	return TST_TestStatus;
} 



/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ExtApp_ATP_AES_Acceptance_MAC_integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using AES
 *  AES modes                   - MAC   
 *  Vector sizes used (in bytes) - 1536                     
 *  Key Size used (in bits)     -  256                               
 *  This also outputs the results to an output buffer or the same input buffer
  * Algorithm:       
 * 1. Call the SEPQA_AES_MAC_Integrated function to use the AES encryption/decryption process
 * 2. Verify function succeded according to the returned error code                                              
 *
 ******************************************************************************/
CRYSError_t CRYS_ExtApp_ATP_AES_Acceptance_MAC_integrated ( void )
{

/********* TST Variables Definitions ************/
	int              TST_index = 0;
	CRYSError_t      TST_TestStatus=0;
	int              TST_OutputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
	char             TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_AES_Acceptance_MAC_integrated";


	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************************************************************* \n"));
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_ExtApp_ATP_AES_Acceptance_MAC_integrated ********************* \n"));      
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************************************************************* \n \n"));

	/************************************************/
	/*********** Start of test **********************/
	/************************************************/
	TST_ATP_EncryptDecryptFlag = 0; 

	for (TST_OutputLocation =0 ; TST_OutputLocation < 2 ;TST_OutputLocation++) 
	{

		if (TST_OutputLocation == 0) 
		{   
			/* output buffer != input buffer    */
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************************************************************\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  %s[test 4A.%d]\n",SEP_AES_MAC_Acceptance_TestData[TST_index].TST_Name,TST_index )); 
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  output buffer != input buffer                                      \n"));       
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************************************************************\n"));
		}
		else
		{
			/* output buffer == input buffer    */
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************************************************************\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  %s[test 4B.%d]\n",SEP_AES_MAC_Acceptance_TestData[TST_index].TST_Name,TST_index));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  output buffer == input buffer (output buffer)                      \n"));                           
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************************************************************\n"));
		}

		TST_TestStatus = TESTPASS;

		/* calling the AES ATP SEP function */ 
		/*----------------------------------*/
		TST_ATP_Error = SEPQA_AES_MAC_Integrated(
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_IvCounter,
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_Key,
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_KeySize,
			TST_EncryptMode[TST_ATP_EncryptDecryptFlag],
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_OperationMode,
			DX_FALSE,
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_input_data, 
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_dataSize,
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_Expected_CBC_MAC,
			SEP_AES_MAC_Acceptance_TestData[TST_index].TST_dataSize,
			TST_OutputLocation,
			FailureFunctionNameOut,
			FailureFunctionName_K_Size
			);



		TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_AES_MAC_Integrated",FailureFunctionNameOut,TST_MasterTestName); 
		#if CRYS_ATP_TST_EXIT_ON_ERROR
				if (TST_TestStatus != TESTPASS) 
					return TESTFAIL;
		#endif

	}/* End of TST_OutputLocation loop*/
	return TST_TestStatus;
	
}



/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ExtApp_ATP_AES_Acceptance_KeyWrapUnwarp      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using AES
 *  Vector sizes used (in bytes) - 512                     
 *  Key Size used (in bits)     -  256                               
 *  This also outputs the results to an output buffer or the same input buffer
  * Algorithm:       
 * 1. Call the SEPQA_AES_KeyWrapUnwarp function to use the AES encryption/decryption process
 * 2. Verify function succeded according to the returned error code                                              
 *
 ******************************************************************************/
CRYSError_t CRYS_ExtApp_ATP_AES_Acceptance_KeyWrapUnwarp ( void )
{

/********* TST Variables Definitions ************/
	int              TST_index = 0;
	CRYSError_t      TST_TestStatus=0;
	char             TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_AES_Acceptance_KeyWrapUnwarp";


	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************************************************************* \n"));
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_ExtApp_ATP_AES_Acceptance_KeyWrapUnwarp ********************* \n"));      
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************************************************************* \n \n"));

	/************************************************/
	/*********** Start of test **********************/
	/************************************************/

		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************************************************************ \n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 5.%d]   **\n",SEP_ARS_KeyWrap_Acceptance_TestData[TST_index].TST_Name,TST_index));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************************************************************ \n"));

		TST_TestStatus = TESTPASS;

		/* calling the AES ATP SEP function */ 
		/*----------------------------------*/
		TST_ATP_Error = SEPQA_AES_KeyWrapUnwarp(
			SEP_ARS_KeyWrap_Acceptance_TestData[TST_index].TST_Key,
			SEP_ARS_KeyWrap_Acceptance_TestData[TST_index].TST_KeySize,
			DX_FALSE,
			SEP_ARS_KeyWrap_Acceptance_TestData[TST_index].TST_InputData, 
			SEP_ARS_KeyWrap_Acceptance_TestData[TST_index].TST_InputDataSize,
			SEP_ARS_KeyWrap_Acceptance_TestData[TST_index].TST_ExpectedWrapedData,
			SEP_ARS_KeyWrap_Acceptance_TestData[TST_index].TST_WrapdDataSize,
			FailureFunctionNameOut,
			FailureFunctionName_K_Size
			);

		TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_AES_KeyWrapUnwarp",
												  SEP_ARS_KeyWrap_Acceptance_TestData[TST_index].TST_Name,
												  TST_MasterTestName);

#if CRYS_ATP_TST_EXIT_ON_ERROR
		if (TST_TestStatus != TESTPASS) 
			return TESTFAIL;
#endif  	
	return TST_TestStatus;
	
}